package jamezo97.clonecraft.block;

import java.util.List;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockSterilizer extends BlockContainer{

	Icon topEmpty = null;
	Icon topFull = null;
	Icon topDirty = null;
	
	public BlockSterilizer(int par1) {
		super(par1, Material.rock);
		setTextureName("CloneCraft:side");
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntitySterilizer();
	}

	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		topEmpty = ir.registerIcon("CloneCraft:sterilizerEmpty");
		topFull = ir.registerIcon("CloneCraft:sterilizerFull");
		topDirty = ir.registerIcon("CloneCraft:sterilizerDirty");
	}
	
	
	
	@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		TileEntity te = par1World.getBlockTileEntity(par2, par3, par4);
		if(te != null && te instanceof TileEntitySterilizer){
			((TileEntitySterilizer)te).dropItems();
		}
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}

	public Icon getDefaultSideIcon(){
		return blockIcon;
	}

	@Override
	public Icon getIcon(int par1, int par2) {
		if(par1 == 1){
			if(par2 == 1 || par2 == 3){
				return topFull;
			}else if(par2 == 2){
				return topDirty;
			}
			return topEmpty;
		}
		return super.getIcon(par1, par2);
	}
	
	
	
	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, 
			int par4, EntityPlayer par5EntityPlayer, int par6, float par7,
			float par8, float par9) {
		ItemStack stack = par5EntityPlayer.getCurrentEquippedItem();
		if(stack != null){
			int stackID = stack.itemID;
			int metaData = par1World.getBlockMetadata(par2, par3, par4);
			if(stackID == Item.bucketEmpty.itemID){
				if(metaData > 0){
					par1World.setBlockMetadataWithNotify(par2, par3, par4, 0, 2);
					((TileEntitySterilizer)par1World.getBlockTileEntity(par2, par3, par4)).dirtiness = 0;
				}
				return true;
			}else if(stackID == Item.bucketWater.itemID){
				if(metaData == 0){
					par1World.setBlockMetadataWithNotify(par2, par3, par4, 1, 2);
					if(!par5EntityPlayer.capabilities.isCreativeMode){
						stack.itemID = Item.bucketEmpty.itemID;
					}
				}
				return true;
			}
		}
		
		
		return false;
	}

	@Override
    public void addCollisionBoxesToList(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity)
    {
        this.setBlockBounds(0.0F, 0.0F, 0.0F, 1.0F, 0.3125F, 1.0F);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        float f = 0.125F;
        this.setBlockBounds(0.0F, 0.0F, 0.0F, f, 1.0F, 1.0F);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        this.setBlockBounds(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, f);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        this.setBlockBounds(1.0F - f, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        this.setBlockBounds(0.0F, 0.0F, 1.0F - f, 1.0F, 1.0F, 1.0F);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        this.setBlockBoundsForItemRender();
    }


    /**
     * Sets the block's bounds for rendering it as an item
     */
    public void setBlockBoundsForItemRender()
    {
        this.setBlockBounds(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
    }

    /**
     * Is this block (a) opaque and (b) a full 1m cube?  This determines whether or not to render the shared face of two
     * adjacent blocks and also whether the player can attach torches, redstone wire, etc to this block.
     */
    public boolean isOpaqueCube()
    {
        return true;
    }

    public int getRenderType()
    {
        return 0;
    }
    

	/**
     * If this block doesn't render as an ordinary block it will return False (examples: signs, buttons, stairs, etc)
     */
    public boolean renderAsNormalBlock()
    {
        return false;
    }
	
    
    
	

}
